/*
 * Decompiled with CFR 0.152.
 */
package CIDBio;

import CIDBio.ConfigParam;
import CIDBio.DeviceInfo;
import CIDBio.IdentifyResult;
import CIDBio.Image;
import CIDBio.ImageAndTemplate;
import CIDBio.MatchResult;
import CIDBio.ParameterResult;
import CIDBio.RetCode;
import CIDBio.Template;
import CIDBio.TemplateIDs;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;

public class CIDBio {
    public static RetCode SetSerialCommPort(String commPort) {
        Memory commPort_ptr = new Memory((long)(commPort.length() + 1));
        commPort_ptr.setString(0L, commPort);
        return RetCode.GetValue(CLibrary.INSTANCE.CIDBIO_SetSerialCommPort((Pointer)commPort_ptr));
    }

    public static RetCode Init() {
        return RetCode.GetValue(CLibrary.INSTANCE.CIDBIO_Init());
    }

    public static RetCode Terminate() {
        return RetCode.GetValue(CLibrary.INSTANCE.CIDBIO_Terminate());
    }

    public static String GetErrorMessage(RetCode error) {
        PointerByReference message_ptr_ptr = new PointerByReference();
        int retCode = CLibrary.INSTANCE.CIDBIO_GetErrorMessage(error.code, message_ptr_ptr);
        if (retCode < RetCode.SUCCESS.code) {
            return "";
        }
        return CIDBio.CopyStringAndDelete(message_ptr_ptr.getValue());
    }

    public Image CaptureImage() {
        PointerByReference pImage_ptr_ptr = new PointerByReference();
        IntByReference width_ptr = new IntByReference();
        IntByReference height_ptr = new IntByReference();
        int retCode = CLibrary.INSTANCE.CIDBIO_CaptureImage(pImage_ptr_ptr, width_ptr, height_ptr);
        int width = width_ptr.getValue();
        int height = height_ptr.getValue();
        byte[] vec = CIDBio.CopyBytesAndDelete(pImage_ptr_ptr.getValue(), width * height);
        return new Image(RetCode.GetValue(retCode), vec, height, width);
    }

    public ImageAndTemplate CaptureImageAndTemplate() {
        PointerByReference temp_ptr_ptr = new PointerByReference();
        PointerByReference image_ptr_ptr = new PointerByReference();
        IntByReference width_ptr = new IntByReference();
        IntByReference height_ptr = new IntByReference();
        IntByReference quality_ptr = new IntByReference();
        int retCode = CLibrary.INSTANCE.CIDBIO_CaptureImageAndTemplate(temp_ptr_ptr, image_ptr_ptr, width_ptr, height_ptr, quality_ptr);
        int width = width_ptr.getValue();
        int height = height_ptr.getValue();
        byte[] vec = CIDBio.CopyBytesAndDelete(image_ptr_ptr.getValue(), width * height);
        String temp = CIDBio.CopyStringAndDelete(temp_ptr_ptr.getValue());
        int quality = quality_ptr.getValue();
        return new ImageAndTemplate(RetCode.GetValue(retCode), vec, height, width, temp, quality);
    }

    public RetCode CaptureAndEnroll(long id) {
        return RetCode.GetValue(CLibrary.INSTANCE.CIDBIO_CaptureAndEnroll(id));
    }

    public IdentifyResult CaptureAndIdentify() {
        LongByReference id_ptr = new LongByReference();
        IntByReference score_ptr = new IntByReference();
        IntByReference quality_ptr = new IntByReference();
        int retCode = CLibrary.INSTANCE.CIDBIO_CaptureAndIdentify(id_ptr, score_ptr, quality_ptr);
        long id = id_ptr.getValue();
        int score = score_ptr.getValue();
        int quality = quality_ptr.getValue();
        return new IdentifyResult(RetCode.GetValue(retCode), id, score, quality);
    }

    public MatchResult CaptureAndMatch(long id) {
        IntByReference score_ptr = new IntByReference();
        IntByReference quality_ptr = new IntByReference();
        int retCode = CLibrary.INSTANCE.CIDBIO_CaptureAndMatch(id, score_ptr, quality_ptr);
        int score = score_ptr.getValue();
        int quality = quality_ptr.getValue();
        return new MatchResult(RetCode.GetValue(retCode), score, quality);
    }

    public Template ExtractTemplateFromImage(int width, int height, byte[] image) {
        PointerByReference temp_ptr_ptr = new PointerByReference();
        IntByReference quality_ptr = new IntByReference();
        Memory image_ptr = new Memory((long)image.length);
        image_ptr.write(0L, image, 0, image.length);
        int retCode = CLibrary.INSTANCE.CIDBIO_ExtractTemplateFromImage(width, height, (Pointer)image_ptr, temp_ptr_ptr, quality_ptr);
        String temp = CIDBio.CopyStringAndDelete(temp_ptr_ptr.getValue());
        int quality = quality_ptr.getValue();
        return new Template(RetCode.GetValue(retCode), temp, quality);
    }

    public Template ExtractTemplateFromImage(Image image) {
        return this.ExtractTemplateFromImage(image.getWidth(), image.getHeight(), image.getImageBuffer());
    }

    public Template MergeTemplates(String t1, String t2, String t3) {
        PointerByReference temp_ptr_ptr = new PointerByReference();
        Memory t1_ptr = new Memory((long)(t1.length() + 1));
        t1_ptr.setString(0L, t1);
        Memory t2_ptr = new Memory((long)(t2.length() + 1));
        t2_ptr.setString(0L, t2);
        Memory t3_ptr = new Memory((long)(t3.length() + 1));
        t3_ptr.setString(0L, t3);
        int retCode = CLibrary.INSTANCE.CIDBIO_MergeTemplates((Pointer)t1_ptr, (Pointer)t2_ptr, (Pointer)t3_ptr, temp_ptr_ptr);
        String temp = CIDBio.CopyStringAndDelete(temp_ptr_ptr.getValue());
        return new Template(RetCode.GetValue(retCode), temp);
    }

    public Template MergeTemplates(Template t1, Template t2, Template t3) {
        return this.MergeTemplates(t1.getTemplate(), t2.getTemplate(), t3.getTemplate());
    }

    public MatchResult MatchTemplates(String t1, String t2) {
        IntByReference score_ptr = new IntByReference();
        Memory t1_ptr = new Memory((long)(t1.length() + 1));
        t1_ptr.setString(0L, t1);
        Memory t2_ptr = new Memory((long)(t2.length() + 1));
        t2_ptr.setString(0L, t2);
        int retCode = CLibrary.INSTANCE.CIDBIO_MatchTemplates((Pointer)t1_ptr, (Pointer)t2_ptr, score_ptr);
        int score = score_ptr.getValue();
        return new MatchResult(RetCode.GetValue(retCode), score);
    }

    public MatchResult MatchTemplates(Template t1, Template t2) {
        return this.MatchTemplates(t1.getTemplate(), t2.getTemplate());
    }

    public MatchResult MatchTemplateByID(long id, String temp) {
        IntByReference score_ptr = new IntByReference();
        Memory temp_ptr = new Memory((long)(temp.length() + 1));
        temp_ptr.setString(0L, temp);
        int retCode = CLibrary.INSTANCE.CIDBIO_MatchTemplateByID(id, (Pointer)temp_ptr, score_ptr);
        int score = score_ptr.getValue();
        return new MatchResult(RetCode.GetValue(retCode), score);
    }

    public MatchResult MatchTemplateByID(long id, Template temp) {
        return this.MatchTemplateByID(id, temp.getTemplate());
    }

    public TemplateIDs GetTemplateIDs() {
        PointerByReference ids_ptr_ptr = new PointerByReference();
        IntByReference len_ptr = new IntByReference();
        int retCode = CLibrary.INSTANCE.CIDBIO_GetTemplateIDs(ids_ptr_ptr, len_ptr);
        int len = len_ptr.getValue();
        long[] ids = CIDBio.CopyIDsAndDelete(ids_ptr_ptr.getValue(), len);
        return new TemplateIDs(RetCode.GetValue(retCode), ids);
    }

    public Template GetTemplate(long id) {
        PointerByReference temp_ptr_ptr = new PointerByReference();
        int retCode = CLibrary.INSTANCE.CIDBIO_GetTemplate(id, temp_ptr_ptr);
        String temp = CIDBio.CopyStringAndDelete(temp_ptr_ptr.getValue());
        return new Template(RetCode.GetValue(retCode), temp);
    }

    public RetCode SaveTemplate(long id, String temp) {
        Memory temp_ptr = new Memory((long)(temp.length() + 1));
        temp_ptr.setString(0L, temp);
        int retCode = CLibrary.INSTANCE.CIDBIO_SaveTemplate(id, (Pointer)temp_ptr);
        return RetCode.GetValue(retCode);
    }

    public RetCode SaveTemplate(long id, Template temp) {
        return this.SaveTemplate(id, temp.getTemplate());
    }

    public RetCode DeleteTemplate(long id) {
        int retCode = CLibrary.INSTANCE.CIDBIO_DeleteTemplate(id);
        return RetCode.GetValue(retCode);
    }

    public RetCode DeleteAllTemplates() {
        int retCode = CLibrary.INSTANCE.CIDBIO_DeleteAllTemplates();
        return RetCode.GetValue(retCode);
    }

    public ParameterResult GetParameter(ConfigParam param) {
        PointerByReference value_ptr_ptr = new PointerByReference();
        int retCode = CLibrary.INSTANCE.CIDBIO_GetParameter(param.parameter, value_ptr_ptr);
        String value = CIDBio.CopyStringAndDelete(value_ptr_ptr.getValue());
        return new ParameterResult(RetCode.GetValue(retCode), value);
    }

    public RetCode SetParameter(ConfigParam param, String value) {
        Memory value_ptr = new Memory((long)(value.length() + 1));
        value_ptr.setString(0L, value);
        int retCode = CLibrary.INSTANCE.CIDBIO_SetParameter(param.parameter, (Pointer)value_ptr);
        return RetCode.GetValue(retCode);
    }

    public DeviceInfo GetDeviceInfo() {
        PointerByReference version_ptr_ptr = new PointerByReference();
        PointerByReference serial_num_ptr_ptr = new PointerByReference();
        PointerByReference model_ptr_ptr = new PointerByReference();
        int retCode = CLibrary.INSTANCE.CIDBIO_GetDeviceInfo(version_ptr_ptr, serial_num_ptr_ptr, model_ptr_ptr);
        String version = CIDBio.CopyStringAndDelete(version_ptr_ptr.getValue());
        String serial_num = CIDBio.CopyStringAndDelete(serial_num_ptr_ptr.getValue());
        String model = CIDBio.CopyStringAndDelete(model_ptr_ptr.getValue());
        return new DeviceInfo(RetCode.GetValue(retCode), version, serial_num, model);
    }

    public RetCode UpdateFirmware(String filePath) {
        Memory filePath_ptr = new Memory((long)(filePath.length() + 1));
        filePath_ptr.setString(0L, filePath);
        int retCode = CLibrary.INSTANCE.CIDBIO_UpdateFirmware((Pointer)filePath_ptr);
        return RetCode.GetValue(retCode);
    }

    public RetCode CancelCapture() {
        return RetCode.GetValue(CLibrary.INSTANCE.CIDBIO_CancelCapture());
    }

    public Image CheckFingerprint() {
        PointerByReference pImage_ptr_ptr = new PointerByReference();
        IntByReference width_ptr = new IntByReference();
        IntByReference height_ptr = new IntByReference();
        int retCode = CLibrary.INSTANCE.CIDBIO_CheckFingerprint(pImage_ptr_ptr, width_ptr, height_ptr);
        int width = width_ptr.getValue();
        int height = height_ptr.getValue();
        byte[] vec = CIDBio.CopyBytesAndDelete(pImage_ptr_ptr.getValue(), width * height);
        return new Image(RetCode.GetValue(retCode), vec, height, width);
    }

    private static String CopyStringAndDelete(Pointer ptr) {
        if (ptr == null) {
            return "";
        }
        String vec = ptr.getString(0L);
        CLibrary.INSTANCE.CIDBIO_FreeString(ptr);
        return vec;
    }

    private static byte[] CopyBytesAndDelete(Pointer ptr, int length) {
        if (ptr == null) {
            return null;
        }
        byte[] vec = ptr.getByteArray(0L, length);
        CLibrary.INSTANCE.CIDBIO_FreeByteArray(ptr);
        return vec;
    }

    private static long[] CopyIDsAndDelete(Pointer ptr, int length) {
        if (ptr == null) {
            return new long[0];
        }
        long[] vec = ptr.getLongArray(0L, length);
        CLibrary.INSTANCE.CIDBIO_FreeIDArray(ptr);
        return vec;
    }

    private static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = (CLibrary)Native.loadLibrary((String)"cidbio", CLibrary.class);

        public int CIDBIO_SetSerialCommPort(Pointer var1);

        public int CIDBIO_Init();

        public int CIDBIO_Terminate();

        public int CIDBIO_CaptureImage(PointerByReference var1, IntByReference var2, IntByReference var3);

        public int CIDBIO_CaptureImageAndTemplate(PointerByReference var1, PointerByReference var2, IntByReference var3, IntByReference var4, IntByReference var5);

        public int CIDBIO_CaptureAndEnroll(long var1);

        public int CIDBIO_CaptureAndIdentify(LongByReference var1, IntByReference var2, IntByReference var3);

        public int CIDBIO_CaptureAndMatch(long var1, IntByReference var3, IntByReference var4);

        public int CIDBIO_CheckFingerprint(PointerByReference var1, IntByReference var2, IntByReference var3);

        public int CIDBIO_CancelCapture();

        public int CIDBIO_ExtractTemplateFromImage(int var1, int var2, Pointer var3, PointerByReference var4, IntByReference var5);

        public int CIDBIO_MergeTemplates(Pointer var1, Pointer var2, Pointer var3, PointerByReference var4);

        public int CIDBIO_MatchTemplates(Pointer var1, Pointer var2, IntByReference var3);

        public int CIDBIO_MatchTemplateByID(long var1, Pointer var3, IntByReference var4);

        public int CIDBIO_GetTemplateIDs(PointerByReference var1, IntByReference var2);

        public int CIDBIO_GetTemplate(long var1, PointerByReference var3);

        public int CIDBIO_SaveTemplate(long var1, Pointer var3);

        public int CIDBIO_DeleteTemplate(long var1);

        public int CIDBIO_DeleteAllTemplates();

        public int CIDBIO_SetParameter(int var1, Pointer var2);

        public int CIDBIO_GetParameter(int var1, PointerByReference var2);

        public int CIDBIO_GetDeviceInfo(PointerByReference var1, PointerByReference var2, PointerByReference var3);

        public int CIDBIO_UpdateFirmware(Pointer var1);

        public int CIDBIO_GetErrorMessage(int var1, PointerByReference var2);

        public int CIDBIO_FreeByteArray(Pointer var1);

        public int CIDBIO_FreeString(Pointer var1);

        public int CIDBIO_FreeIDArray(Pointer var1);
    }
}

